@extends('backend.layouts.admin')

@section('title', "Demandes en attente d'orientation")

@section('content')
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="text-center">
                <h3 class="bg-primary rounded p-3 mb-4">Liste des demandes en attente d'orientation</h3>
            </div>
        </div>
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <table class="table table-bordered table-striped table-hover">
                    <thead class="table-success">
                        <tr>
                            <th>N°</th>
                            <th>Demandeur</th>
                            <th>Titre Demande</th>
                            <th>Type Demande</th>
                            <th>Docuement(s) Joint(s)</th>
                            <th>Commentaire</th>
                            <th>Date Envoi</th>
                            <th>Staut Demande</th>
                            <th>Direction</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (isset($demandes) && $demandes->count() > 0)
                        @foreach ($demandes as $key => $demande)
                        <tr>
                            <td>{{ ($key + 1) }}</td>
                            <td>{{ $demande->promoteur->nom_entreprise }}</td>
                            <td>{{ $demande->titre_demande }}</td>
                            <td>{{ $demande->typeDocument->libelle }}</td>
                            <td>
                                @php $attachments = $demande->documents_joints; @endphp
                                @foreach ($attachments as $attachment)
                                <div class="mb-3">
                                    <a target="_blank" href="{{ url('storage/documents_recus/'.$attachment) }}"
                                        title="Cliquer pour visualier ou télécharger">
                                        {{ $attachment }}
                                    </a>
                                </div>
                                @endforeach
                            </td>
                            <td>{!! $demande->commentaire !!}</td>
                            <td>{{ Utilities::formatDate($demande->date_demande) }}</td>
                            @php
                            $color = '';
                            if ($demande->id_statut_demande == 2){
                            $color = '#f2b707';
                            }
                            if ($demande->id_statut_demande == 3){
                            $color = '#0cc0e4';
                            }
                            if ($demande->id_statut_demande == 4){
                            $color = '#e443b1';
                            }
                            if ($demande->id_statut_demande == 5){
                            $color = '#dc3545';
                            }
                            if ($demande->id_statut_demande == 6){
                            $color = '#188050';
                            }
                            @endphp
                            <td class="fw-bold" style="color: {{ $color ?? '#444444' }}">
                                {{ $demande->statutDemande->libelle }}
                            </td>
                            <td>{{ $demande->typeDocument->service->direction->nom }}</td>
                            <td class="text-center">
                                <div class="btn-group" role="group">
                                    @hasrole('ministre')
                                    @if ($demande->id_statut_demande == 1)
                                    <a class="btn btn-warning" href="#"
                                        onclick="orientDemande({{ $demande->id_demande }})">Orienter</a>
                                    <a class="btn btn-danger" href="#" data-bs-toggle="modal"
                                        data-bs-target="#modalReject-{{ $demande->id_demande }}">Rejeter</a>
                                    @endif
                                    @endhasrole
                                    @hasanyrole(Admin::getDirectionRoles())
                                    @if ($demande->id_statut_demande == 2)
                                    <a class="btn btn-warning" href="#"
                                        onclick="orientDemande({{ $demande->id_demande }})">Orienter</a>
                                    @endif
                                    @endhasanyrole
                                    @hasanyrole(Admin::getServiceRoles())
                                    @if ($demande->id_statut_demande == 3)
                                    {{-- <a class="btn btn-warning"
                                        href="{{ route('dashboard.demande.show', $demande->id_demande) }}"
                                        title="Cliquer pour voir les détails"><i class="fa fa-eye"
                                            aria-hidden="true"></i></a> --}}
                                    <a class="btn btn-info"
                                        href="{{ route('dashboard.demande.process', $demande->id_demande) }}">Traiter</a>
                                    <a class="btn btn-warning"
                                        href="{{ route('dashboard.demande.return', $demande->id_demande) }}">Renvoyer</a>
                                    {{-- <a class="btn btn-warning" href="#" data-bs-toggle="modal"
                                        data-bs-target="#modalReturn-{{ $demande->id_demande }}">Renvoyer</a> --}}
                                    @endif
                                    @endhasanyrole
                                </div>
                            </td>
                        </tr>
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection