@extends('backend.layouts.admin')

@section('title', 'Demandes en attente de modification')

@section('content')
<div class="container-fluid pt-4 px-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="text-center">
                <h3 class="bg-primary rounded p-3 mb-4">Liste des demandes en attente de modification</h3>
            </div>
        </div>
        <div class="col-12">
            <div class="bg-secondary rounded h-100 p-4">
                <table class="table table-bordered table-striped table-hover dataTables">
                    <thead class="table-success">
                        <tr>
                            <th>N°</th>
                            <th>Demandeur</th>
                            <th>Titre Demande</th>
                            <th>Type Demande</th>
                            <th>Date Envoi</th>
                            <th>Direction</th>
                            <th>Staut Demande</th>
                            <th>Date Renvoi</th>
                            <th>Motif Renvoi</th>
                            <th>Document Transmis</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if (isset($demandes) && $demandes->count() > 0)
                        @foreach ($demandes as $key => $demande_r)
                        <tr>
                            <td>{{ ($key + 1) }}</td>
                            <td>{{ $demande_r->demande->promoteur->nom_entreprise }}</td>
                            <td>{{ $demande_r->demande->titre_demande }}</td>
                            <td>{{ $demande_r->demande->typeDocument->libelle }}</td>
                            <td>{{ Utilities::formatDate($demande_r->demande->date_demande) }}</td>
                            <td>{{ $demande_r->demande->typeDocument->service->direction->nom }}</td>
                            @php
                            $color = '';
                            if ($demande_r->demande->id_statut_demande == 2){
                            $color = '#f2b707';
                            }
                            if ($demande_r->demande->id_statut_demande == 3){
                            $color = '#0cc0e4';
                            }
                            if ($demande_r->demande->id_statut_demande == 4){
                            $color = '#e443b1';
                            }
                            if ($demande_r->demande->id_statut_demande == 5){
                            $color = '#dc3545';
                            }
                            if ($demande_r->demande->id_statut_demande == 6){
                            $color = '#188050';
                            }
                            @endphp
                            <td class="fw-bold" style="color: {{ $color ?? '#444444' }}">
                                {{ $demande_r->demande->statutDemande->libelle }}
                            </td>
                            <td>{{ Utilities::formatDate($demande_r->date_renvoi) }}</td>
                            <td class="text-center">
                                @if ($demande_r->motif_renvoi != NULL)
                                <a class="btn btn-info" href="#" data-bs-toggle="modal"
                                    data-bs-target="#modalRejectDetail-{{ $demande_r->id_demande }}"
                                    title="Cliquer pour voir le détail">
                                    <i class="fa fa-eye"></i>
                                </a>
                                @endif
                            </td>
                            <td>
                                @php $attachments = $demande_r->documents_joints; @endphp
                                @foreach ($attachments as $attachment)
                                <div class="mb-3">
                                    <a target="_blank" href="{{ url('storage/documents_recus/'.$attachment) }}"
                                        title="Cliquer pour visualier ou télécharger">
                                        {{ $attachment }}
                                    </a>
                                </div>
                                @endforeach
                            </td>
                        </tr>
                        <div class="modal fade" id="modalRejectDetail-{{ $demande_r->id_demande }}" tabindex="-1"
                            aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="bg-secondary modal-content">
                                    <div class="modal-header bg-primary">
                                        <h1 class="modal-title fs-5 text-secondary" id="staticBackdropLabel">Motif du
                                            renvoi</h1>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="p-4">
                                        {!! $demande_r->motif_renvoi !!}
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-primary"
                                            data-bs-dismiss="modal">Quitter</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection