@extends('backend.layouts.admin')

@section('content')
    <!-- Sale & Revenue Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-sm-6 col-xl-3">
                <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                    <i class="fa fa-calculator fa-3x text-primary"></i>
                    <p class="mb-2 text-white fw-bold">Total</p>
                    <div class="ms-3" style="height: 132px">
                        <div class="mb-3">
                            <p class="mb-2">Documents</p>
                            <!-- Affichez le nombre total de demandes ici -->
                            <h6 class="mb-0">{{ $totalDocuments }}</h6>
                        </div>
                        <div class="mb-3">
                            <p class="mb-2">Solde</p>
                            <!-- Affichez le montant total des demandes ici -->
                            <h6 class="mb-0">{{ $totalAmount }}</h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                    <i class="fa fa-building-o fa-3x text-primary"></i>
                    <p class="mb-2 text-white fw-bold">APIP</p>
                    <div class="ms-3" style="height: 132px">
                        <div class="mb-3">
                            <p class="mb-2">Documents</p>
                            <!-- Ajouter un lien vers la page de détails de la direction APIP -->
                            <a href="{{ route('detailDashboard', ['id_direction' => 1]) }}">
                                <h6 class="mb-0">{{$apipDocumentsCount}}</h6>
                            </a>
                        </div>
                        <div class="mb-3">
                            <p class="mb-2">Solde</p>
                            <h6 class="mb-0">{{$apipTotalAmount}} GNF</h6>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-xl-3">
                <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                    <i class="fa-solid fa-file-export fa-3x text-primary"></i>
                    <p class="mb-2 text-white fw-bold">AGUIPEX</p>
                    <div class="ms-3"style="height: 132px">
                        <div class="mb-3">
                            <p class="mb-2">Documents</p>
                            <h6 class="mb-0">{{$aguipexDocumentsCount}}</h6>
                        </div>
                        <div class="mb-3">
                            <p class="mb-2">Solde</p>
                            <h6 class="mb-0">{{$aguipexTotalAmount}} GNF</h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                    <i class="fa fa-chart-area fa-3x text-primary"></i>
                    <p class="mb-2 text-white fw-bold">DNI</p>
                    <div class="ms-3"style="height: 132px">
                        <div class="mb-3">
                            <p class="mb-2">Documents</p>
                            <h6 class="mb-0">{{$dniDocumentsCount}}</h6>
                        </div>
                        <div class="mb-3">
                            <p class="mb-2">Solde</p>
                            <h6 class="mb-0">{{$dniTotalAmount}} GNF</h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                    <i class="fa fa-snowflake-o fa-3x text-primary"></i>
                    <p class="mb-2 text-white fw-bold">ONCQ</p>
                    <div class="ms-3"style="height: 132px">
                        <div class="mb-3">
                            <p class="mb-2">Documents</p>
                            <h6 class="mb-0">{{$oncqDocumentsCount}}</h6>
                        </div>
                        <div class="mb-3">
                            <p class="mb-2">Solde</p>
                            <h6 class="mb-0">{{$oncqTotalAmount}} GNF</h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                    <i class="fa fa-chart-pie fa-3x text-primary"></i>
                    <p class="mb-2 text-white fw-bold">DDI/DDE</p>
                    <div class="ms-3"style="height: 132px">
                        <div class="mb-3">
                            <p class="mb-2">Documents</p>
                            <h6 class="mb-0">{{$ddiddeDocumentsCount}}</h6>
                        </div>
                        <div class="mb-3">
                            <p class="mb-2">Solde</p>
                            <h6 class="mb-0">{{$ddiddeTotalAmount}} GNF</h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                    <i class="fa fa-chart-pie fa-3x text-primary"></i>
                    <p class="mb-2 text-white fw-bold">IGNM</p>
                    <div class="ms-3"style="height: 132px">
                        <div class="mb-3">
                            <p class="mb-2">Documents</p>
                            <h6 class="mb-0">{{$ignmDocumentsCount}}</h6>
                        </div>
                        <div class="mb-3">
                            <p class="mb-2">Solde</p>
                            <h6 class="mb-0">{{$ignmTotalAmount}} GNF</h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-xl-3">
                <div class="bg-secondary rounded d-flex align-items-center justify-content-between p-4">
                    <i class="fa fa-chart-pie fa-3x text-primary"></i>
                    <p class="mb-2 text-white fw-bold">DNCIC</p>
                    <div class="ms-3"style="height: 132px">
                        <div class="mb-3">
                            <p class="mb-2">Documents</p>
                            <h6 class="mb-0">{{$dncicDocumentsCount}}</h6>
                        </div>
                        <div class="mb-3">
                            <p class="mb-2">Solde</p>
                            <h6 class="mb-0">{{$dncicTotalAmount}} GNF</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Sale & Revenue End -->


    <!-- Sales Chart Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-sm-12 col-xl-6">
                <div class="bg-secondary text-center rounded p-4">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        {{-- <h6 class="mb-0">Montant</h6> --}}
                        {{-- <a href="">Show All</a> --}}
                    </div>
                    <canvas id="worldwide-sales"></canvas>
                </div>
            </div>
            <div class="col-sm-12 col-xl-6">
                <div class="bg-secondary text-center rounded p-4">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        {{-- <h6 class="mb-0">Montant</h6> --}}
                        {{-- <a href="">Show All</a> --}}
                    </div>
                    <canvas id="salse-revenue"></canvas>
                </div>
            </div>
        </div>
    </div>
@endsection
