@extends('backend.layouts.admin')

@section('title', 'List des entités sources')

@section('content')
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="text-center">
                    <h3 class="bg-primary rounded p-3 mb-4">Liste des catégorie de documents</h3>
                </div>
            </div>
            <div class="row">
                <div class="text-center">
                    <a class="btn btn-light" href="{{ route('categorie_document.create') }}"><i class="fa fa-plus-circle">&nbsp;Ajouter une catégorie de document</i></a>
                </div>
            </div>
            <div class="col-12">
                <div class="bg-secondary rounded h-100 p-4">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr class="text-center text-uppercase">
                                    <th scope="col">#</th>
                                    <th scope="col">Nom de la cétégorie de document</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($categories->isEmpty())
                                        <tr>
                                            <td colspan="7" class="text-center">Aucune catégorie trouvée.</td>
                                        </tr>
                                @else
                                    @foreach ($categories as $i => $category)
                                        <tr>
                                            <th scope="row">{{ ($i+1) }}</th>
                                            <td>{{ $category->libelle }}</td>
                                            <td class="text-center">
                                                <div class="btn-group" role="group">
                                                    <a class="btn btn-warning" href="{{ route('categorie_document.edit', $category) }}">Modifier</a>
                                                    <a class="btn btn-danger" href="#" onclick="deleteCategory({{ $category->id_categorie_document }})">Supprimer</a>
                                                </div>
                                            </td>
                                        </tr>
                                        <script>
                                            function deleteCategory(category) {
                                                Swal.fire({
                                                    title: "Êtes-vous sûr?",
                                                    text: "Vous ne pourrez pas revenir en arrière!",
                                                    icon: "warning",
                                                    showCancelButton: true,
                                                    confirmButtonColor: "#3085d6",
                                                    cancelButtonColor: "#d33",
                                                    confirmButtonText: "Oui, supprimer!"
                                                }).then((result) => {
                                                    if (result.isConfirmed) {
                                                        window.location = "{{ route('categorie_document.delete', ':category') }}".replace(':category', category);
                                                    }
                                                });
                                            }
                                        </script>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection