<!-- Sidebar Start -->
<div class="sidebar pe-4 pb-3">
    <nav class="navbar bg-secondary navbar-dark">
        <a href="{{ route('home') }}" class="navbar-brand mx-4 mb-3">
            <img class="bg-white p-1" src="{{ url('assets/images/logos/logo_plaged.png') }}" width="200" alt="">
        </a>
        <div class="d-flex align-items-center ms-4 mb-4">
            <div class="position-relative">
                <img class="rounded-circle" src="{{ url('assets/images/profile-pictures/user.png') }}" alt=""
                    style="width: 40px; height: 40px;">
                <div
                    class="bg-success rounded-circle border border-2 border-white position-absolute end-0 bottom-0 p-1">
                </div>
            </div>
            <div class="ms-3">
                <h6 class="mb-0">{{ auth()->user()->first_name }}</h6>
                {{-- <span>Amdin</span> --}}
            </div>
        </div>
        <div class="navbar-nav w-100">
            <!-- Dashboard -->
            <a href="{{ route('dashboard') }}" class="nav-item nav-link {{ Route::is('dashboard') ? 'active' : '' }}"><i
                    class="fa fa-tachometer-alt me-2"></i>
                Dashboard
            </a>
            @hasanyrole(Admin::getAllImportantRoles())
            <!-- Demandes -->
            <div class="nav-item dropdown">
                <a href="{{ route('dashboard.demande.list') }}"
                    class="nav-link dropdown-toggle {{ Route::is('dashboard.demande.list') ||  Route::is('dashboard.demande.category') ? 'active' : '' }}"
                    data-bs-toggle="dropdown"><i class="fa fa-folder me-2"></i>Demandes</a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('dashboard.demande.list') }}" class="dropdown-item {{ Route::is('dashboard.demande.list') ? 'active' : '' }}">Toutes les demandes</a>
                    @hasrole('ministre')
                        <a href="{{ route('dashboard.demande.category', 'processing') }}" class="dropdown-item {{ Request::is('dashboard/demandes/processing/list') ? 'active' : '' }}">En attente d'orientation</a>
                        <a href="{{ route('dashboard.demande.category', 'study') }}" class="dropdown-item {{ Request::is('dashboard/demandes/study/list') ? 'active' : '' }}">En attente d'étude</a>
                        <a href="{{ route('dashboard.demande.category', 'review') }}" class="dropdown-item {{ Request::is('dashboard/demandes/review/list') ? 'active' : '' }}">En attente d'examen</a>
                        <a href="{{ route('dashboard.demande.category', 'modification') }}" class="dropdown-item {{ Request::is('dashboard/demandes/modification/list') ? 'active' : '' }}">En attente de modification</a>
                        <a href="{{ route('dashboard.demande.category', 'rejected') }}" class="dropdown-item {{ Request::is('dashboard/demandes/rejected/list') ? 'active' : '' }}">Rejetées</a>
                        <a href="{{ route('dashboard.demande.category', 'processed') }}" class="dropdown-item {{ Request::is('dashboard/demandes/processed/list') ? 'active' : '' }}">Traitées</a>
                    @endhasrole
                </div>
            </div>
            @endhasanyrole
            @hasanyrole(Admin::getAdminRoles())
            <!-- Users -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('admin.user.list') ||
                        Route::is('admin.user.add') ||
                        Route::is('admin.user.edit') ||
                        Route::is('admin.user.details')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="fa fa-users me-2"></i>
                    Utilisateurs
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('admin.user.list') }}"
                        class="dropdown-item {{ Route::is('admin.user.list') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des Utilisateurs</a>
                    <a href="{{ route('admin.user.add') }}"
                        class="dropdown-item {{ Route::is('admin.user.add') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajout Utilisateur</a>
                </div>
            </div>
            <!-- Roles -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('admin.role.list') ||
                        Route::is('admin.role.add') ||
                        Route::is('admin.role.edit') ||
                        Route::is('admin.role.details')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Rôles
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('admin.role.list') }}"
                        class="dropdown-item {{ Route::is('admin.role.list') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des Rôles</a>
                    <a href="{{ route('admin.role.add') }}"
                        class="dropdown-item {{ Route::is('admin.role.add') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajout Rôle</a>
                </div>
            </div>
            <!-- Permissions -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('admin.permission.list') || Route::is('admin.permission.add') || Route::is('admin.permission.edit')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Privilèges
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('admin.permission.list') }}"
                        class="dropdown-item {{ Route::is('admin.permission.list') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des Privilèges</a>
                    <a href="{{ route('admin.permission.add') }}"
                        class="dropdown-item {{ Route::is('admin.permission.add') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajout Privilège</a>
                </div>
            </div>
            <!-- Source Ministere -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('minister.index') || Route::is('minister.create') || Route::is('minister.edit')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Ministère
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('minister.index') }}"
                        class="dropdown-item {{ Route::is('minister.index') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des minitères</a>
                    <a href="{{ route('minister.create') }}"
                        class="dropdown-item {{ Route::is('minister.create') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajouter un ministère</a>
                </div>
            </div>

            <!-- Source Direction -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('direction.index') || Route::is('direction.create') || Route::is('direction.edit')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Direction
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('direction.index') }}"
                        class="dropdown-item {{ Route::is('direction.index') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des directions</a>
                    <a href="{{ route('direction.create') }}"
                        class="dropdown-item {{ Route::is('direction.create') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajouter une direction</a>
                </div>
            </div>
            <!-- Source Service -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('service.index') || Route::is('service.create') || Route::is('service.edit')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Service
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('service.index') }}"
                        class="dropdown-item {{ Route::is('service.index') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des services</a>
                    <a href="{{ route('service.create') }}"
                        class="dropdown-item {{ Route::is('service.create') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajouter un service</a>
                </div>
            </div>

            <!-- Source responsable -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('responsable.index') || Route::is('responsable.create') || Route::is('responsable.edit')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Responsable
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('responsable.index') }}"
                        class="dropdown-item {{ Route::is('responsable.index') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des responsables</a>
                    <a href="{{ route('responsable.create') }}"
                        class="dropdown-item {{ Route::is('responsable.create') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajouter un responsable</a>
                </div>
            </div>

            <!-- Source promoteur -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('promoteur.index') || Route::is('promoteur.create') || Route::is('promoteur.edit')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Promoteur
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('promoteur.index') }}"
                        class="dropdown-item {{ Route::is('promoteur.index') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des promoteurs</a>
                    <a href="{{ route('promoteur.create') }}"
                        class="dropdown-item {{ Route::is('promoteur.create') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajouter un promoteur</a>
                </div>
            </div>

            <!-- Source Catégorie de document -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('categorie_document.index') || Route::is('categorie_document.create') || Route::is('categorie_document.edit')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Catégorie doc.
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('categorie_document.index') }}"
                        class="dropdown-item {{ Route::is('categorie_document.index') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des catégories</a>
                    <a href="{{ route('categorie_document.create') }}"
                        class="dropdown-item {{ Route::is('categorie_document.create') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajouter une catégorie</a>
                </div>
            </div>

            <!-- Source Catégorie de document -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('type_document.index') || Route::is('type_document.create') || Route::is('type_document.edit')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Type de doc.
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('type_document.index') }}"
                        class="dropdown-item {{ Route::is('type_document.index') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des types</a>
                    <a href="{{ route('type_document.create') }}"
                        class="dropdown-item {{ Route::is('type_document.create') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajouter un type</a>
                </div>
            </div>
            <!-- Products -->
            <div class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle {{ Route::is('produit.index') || Route::is('produit.create') || Route::is('produit.edit')
                            ? 'active'
                            : '' }}" data-bs-toggle="dropdown"><i class="far fa-folder me-2"></i>
                    Produits
                </a>
                <div class="dropdown-menu bg-transparent border-0">
                    <a href="{{ route('produit.index') }}"
                        class="dropdown-item {{ Route::is('produit.index') ? 'active' : '' }}"><i
                            class="fa fa-table me-2"></i>Liste des Produits</a>
                    <a href="{{ route('produit.create') }}"
                        class="dropdown-item {{ Route::is('produit.create') ? 'active' : '' }}"><i
                            class="fa fa-keyboard me-2"></i>Ajouter Produit</a>
                </div>
            </div>
            @endhasanyrole
        </div>
    </nav>
</div>
<!-- Sidebar End -->