<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <meta name="description" content="">
	    <meta name="author" content="Mamadi Cissé">
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <link rel="icon" href="{{ url('assets/images/logos/armoirerie.png') }}">

	    <title>{{ config('app.name', 'Laravel') }} - @yield('title')</title>

        <!-- Icon Font Stylesheet -->
        {{-- <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet"> --}}
        <!-- Fonts Awesome -->
        <link rel="stylesheet" href="{{ url('assets/css/font-awesome.css') }}">
        <script src="{{ url('assets/js/kit.fontawesome.js') }}"></script>

        <!-- Owl Carousel CSS -->
        <link href="{{ url('owlcarousel/assets/owl.carousel.min.css') }}" rel="stylesheet">
        <link href="{{ url('owlcarousel/assets/owl.theme.default.min.css') }}" rel="stylesheet">

        <!-- Tempus Dominus CSS -->
        <link href="{{ url('tempusdominus/css/tempusdominus-bootstrap-4.min.css') }}" rel="stylesheet" />

        <!-- Customized Bootstrap Stylesheet -->
        <link href="{{ url('admin/css/customized-bootstrap.min.css') }}" rel="stylesheet">

        <!-- Template Stylesheet -->
        <link href="{{ url('admin/css/style.css') }}" rel="stylesheet">
        
        <!-- Hightcharts JS -->
        <script src="{{ asset('highcharts/highcharts.js')}}"></script>
        <script src="{{ asset('highcharts/highcharts-3d.js')}}"></script>
        <script src="{{ asset('highcharts/modules/exporting.js')}}"></script>
        <script src="{{ asset('highcharts/modules/export-data.js')}}"></script>
        <script src="{{ asset('highcharts/modules/accessibility.js')}}"></script>
        
        <!-- DataTables  CSS -->
        <link rel="stylesheet" href="{{ url('dataTables/css/datatables.min.css') }}">
        
        <!-- Sweetalert2  CSS -->
        <link rel="stylesheet" href="{{ url('assets/css/sweetalert2.min.css') }}">
    </head>
    <body>
        <div class="container-fluid position-relative d-flex p-0">
            <!-- Spinner -->
            @include('backend.layouts.inc._spinner')

            <!-- Sidebar -->
            @include('backend.layouts.inc._sidebar')

            <!-- Content Start -->
            <div class="content">
                <!-- Navbar -->
                @include('backend.layouts.inc._navbar')
                
                @yield('content')

                <!-- Footer -->
                @include('backend.layouts.inc._footer')
            </div>
            <!-- Content End -->
            
            <!-- Back to Top -->
            <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="fas fa-arrow-up"></i></a>
        </div>

        <!-- JavaScript Libraries -->
        <script src="{{ url('assets/js/jquery-3.7.1.min.js') }}"></script>
        <script src="{{ url('bootstrap/js/bootstrap.bundle.min.js') }}"></script>
        <script src="{{ url('chart/chart.min.js') }}"></script>
        <script src="{{ url('easing/easing.min.js') }}"></script>
        <script src="{{ url('waypoints/waypoints.min.js') }}"></script>
        <script src="{{ url('owlcarousel/owl.carousel.min.js') }}"></script>
        <script src="{{ url('tempusdominus/js/moment.min.js') }}"></script>
        <script src="{{ url('tempusdominus/js/moment-timezone.min.js') }}"></script>
        <script src="{{ url('tempusdominus/js/tempusdominus-bootstrap-4.min.js') }}"></script>

        <!-- Template Javascript -->
        <script src="{{ url('admin/js/main.js') }}"></script>

        <!-- Custom JS -->
        <script src="{{ url('assets/js/main.js') }}"></script>

        <!-- Sweetalert2 JS -->
        <script src="{{ url('assets/js/sweetalert2.all.min.js') }}"></script>
        
        <!-- CKEditor -->
        <script src="{{ url('ckeditor5/ckeditor.js') }}"></script>

        <!-- CKEditor Configuration -->
        <script>
            ClassicEditor
                .create(document.querySelector( '#ckeditor' ), {
                    toolbar: {
                        items: [
                            'exportPDF','exportWord', '|',
                            'findAndReplace', 'selectAll', '|',
                            'heading', '|',
                            'bold', 'italic', 'strikethrough', 'underline', 'code', 'subscript', 'superscript', 'removeFormat', '|',
                            'bulletedList', 'numberedList', 'todoList', '|',
                            'outdent', 'indent', '|',
                            'undo', 'redo',
                            '-',
                            'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', 'highlight', '|',
                            'alignment', '|',
                            'link', 'insertImage', 'blockQuote', 'insertTable', 'mediaEmbed', 'codeBlock', 'htmlEmbed', '|',
                            'specialCharacters', 'horizontalLine', 'pageBreak', '|',
                            'textPartLanguage', '|',
                            'sourceEditing'
                        ],
                        shouldNotGroupWhenFull: false
                    },
                    fontFamily: {
                        options: [
                            'default',
                            'Arial, Helvetica, sans-serif',
                            'Courier New, Courier, monospace',
                            'Georgia, serif',
                            'Lucida Sans Unicode, Lucida Grande, sans-serif',
                            'Tahoma, Geneva, sans-serif',
                            'Times New Roman, Times, serif',
                            'Trebuchet MS, Helvetica, sans-serif',
                            'Verdana, Geneva, sans-serif'
                        ],
                        supportAllValues: true
                    },
                    fontSize: {
                        options: [ 10, 12, 14, 'default', 18, 20, 22 ],
                        supportAllValues: true
                    },
                    ckfinder: {
                        uploadUrl: "",
                        options: {
                            resourceType: 'Images'
                        }
                    }                    
                })
                .then(editor => {
                    console.log(editor);
                })
                .catch(error => {
                    console.error(error);
                }
            );
        </script>

        <!-- DataTables  JS -->
        <script src="{{ url('dataTables/js/datatables.min.js') }}"></script>
        <script src="{{ url('dataTables/js/pdfmake.min.js') }}"></script>
        <script src="{{ url('dataTables/js/vfs_fonts.js') }}"></script>

        <script>
            new DataTable('.dataTables');
        </script>

        <!-- Information Message -->
        @if (session()->has('info'))
            <script>
                Swal.fire({
                    // title: "Information!",
                    text: "{!!session()->get('info')!!}",
                    icon: "info",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        @endif
        <!-- Success Message -->
        @if (session()->has('success'))
            <script>
                Swal.fire({
                    // title: "Success!",
                    text: "{!!session()->get('success')!!}",
                    icon: "success",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        @endif
        <!-- Warning Message -->
        @if (session()->has('warning'))
            <script>
                Swal.fire({
                    // title: "Warning!",
                    text: "{!!session()->get('warning')!!}",
                    icon: "warning",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        @endif
        <!-- Error Message -->
        @if (session()->has('error'))
            <script>
                Swal.fire({
                    // title: "Error!",
                    text: "{!!session()->get('error')!!}",
                    icon: "error",
                    showCloseButton: true,
                    // showCancelButton: true,
                });
            </script>
        @endif
        
        <!-- Auto Log Out -->
        @auth
            <script src="{{ url('session.js') }}"></script>
        @endauth
    </body>
</html>