@extends('frontend.layouts.default')

@section('title', 'Nouveau mot de passe')

@section('content')
    <div id="auth-form" class="container-fluid position-relative d-flex p-0">
        <div class="container-fluid">
            <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
                <div class="col-12 col-sm-11 col-md-8 col-lg-6 col-xl-5">
                    <div class="bg-primary rounded p-4 p-sm-5 my-4 mx-3">
                        <form action="{{ route('password.update') }}" method="post">
                            @csrf
                            <div class="d-flex align-items-center justify-content-center mb-3">
                                <a href="https://mcipme.gov.gn/" target="_blank">
                                    <img src="{{ url('assets/images/logos/logo_plaged.png') }}" width="400" alt="">
                                </a>
                            </div>
                            <div class="text-center mb-3">
                                {{-- <a href="{{ route('home') }}" class="text-decoration-none">
                                    <h3 class="text-secondary"><i class="fa fa-user-edit me-2"></i>PAI</h3>
                                </a> --}}
                                <h3 class="text-secondary"><i class="fa fa-user-edit me-2"></i>&nbsp;Modification du mot de passe</h3>
                            </div>
                            <div>
                                <div class="p-1 my-3" style="background-color: beige; font-size: 14px;">Le symbole astérisque <strong><code>( * )</code></strong> signifie que le champ est obligatoire</div>
                            </div>
                            <div class="form-floating mb-3">
                                <input type="hidden" name="token" value="{{ $token }}">
                                <input type="email" name="email" value="{{ $email ?? old('email') }}" class="form-control @error('email') is-invalid @enderror" id="floatingInput" placeholder="name@example.com">
                                <label for="floatingInput">Adresse email * :</label>
                                @error('email')
                                    <span class="invalid-feedback">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
                            <div class="form-floating mb-4">
                                <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" id="floatingPassword" placeholder="Password">
                                <label for="floatingPassword">Mot de passe * :</label>
                                @error('password')
                                    <span class="invalid-feedback">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
                            <div class="form-floating mb-4">
                                <input type="password" name="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" id="floatingPassword" placeholder="Password">
                                <label for="floatingPassword">Confirmer le Mot de passe * :</label>
                                @error('password_confirmation')
                                    <span class="invalid-feedback">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-secondary py-3 w-100 mb-4">Valider le mot de passe</button>
                            {{-- <p class="text-center mb-0">
                                <div style="float: left">
                                    <a href="{{ route('login') }}" title="Cliquer pour se connecter" class="text-secondary text-start">
                                        Se connecter
                                    </a>
                                </div>
                            </p> --}}
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
