@extends('frontend.layouts.default')

@section('title', 'Inscription')

@section('content')
    <div id="auth-form" class="container-fluid position-relative d-flex p-0">
        <div class="container-fluid">
            <div class="row h-100 align-items-center justify-content-center" style="min-height: 100vh;">
                <div class="col-12 col-sm-11 col-md-9 col-lg-8 col-xl-6">
                    <div class="bg-primary rounded p-4 p-sm-5 my-4 mx-3">
                        <form action="{{ route('register.store') }}" method="post">
                            @csrf
                            <div class="d-flex align-items-center justify-content-center mb-3">
                                <a href="https://mcipme.gov.gn/" target="_blank">
                                    <img src="{{ url('assets/images/logos/logo_plaged.png') }}" width="400" alt="">
                                </a>
                            </div>
                            <div class="text-center mb-3">
                                {{-- <a href="{{ route('home') }}" class="text-decoration-none">
                                    <h3 class="text-secondary"><i class="fa fa-user-edit me-2"></i>PAI</h3>
                                </a> --}}
                                <h3 class="text-secondary"><i class="fa fa-user-edit me-2"></i>&nbsp;Inscription</h3>
                            </div>
                            <div class="row">
                                <div>
                                    <div class="p-1 my-3" style="background-color: beige; font-size: 14px;">Le symbole astérisque <strong><code>( * )</code></strong> signifie que le champ est obligatoire</div>
                                </div>
                                <!-- Prénom -->
                                <div class="col-sm-12 col-md-6 col-lg-6">
                                    <div class="form-floating mb-3">
                                        <input type="text" name="first_name" value="{{ old('first_name') }}" class="form-control @error('first_name') is-invalid @enderror" id="floatingText" placeholder="jhondoe">
                                        <label for="floatingText">Prénom * :</label>
                                        @error('first_name')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <!-- Nom -->
                                <div class="col-sm-12 col-md-6 col-lg-6">
                                    <div class="form-floating mb-3">
                                        <input type="text" name="last_name" value="{{ old('last_name') }}" class="form-control @error('last_name') is-invalid @enderror" id="floatingText" placeholder="jhondoe">
                                        <label for="floatingText">Nom * :</label>
                                        @error('last_name')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- Genre -->
                                <div class="col-sm-12 col-md-6 col-lg-6">
                                    <div class="mb-3">
                                        <select name="gender" class="form-select @error('gender') is-invalid @enderror" style="height:58px;line-height:1.25;">
                                            <option value="">Genre * :</option>
                                            @isset($genres)
                                                @foreach ($genres as $genre)
                                                    <option {{ old('gender') == $genre->id_genre ? 'selected' : '' }} value="{{ $genre->id_genre }}">{{ $genre->libelle }} </option>
                                                @endforeach                                                
                                            @endisset
                                        </select>
                                        @error('gender')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <!-- Entreprise -->
                                <div class="col-sm-12 col-md-6 col-lg-6">
                                    <div class="form-floating mb-3">
                                        <input type="text" name="company" value="{{ old('company') }}" class="form-control @error('company') is-invalid @enderror" id="floatingText" placeholder="jhondoe">
                                        <label for="floatingText">Entreprise * :</label>
                                        @error('company')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <!-- Email -->
                                <div class="col-sm-12 col-md-6 col-lg-6">
                                    <div class="form-floating mb-3">
                                        <input type="email" name="email" value="{{ old('email') }}" class="form-control @error('email') is-invalid @enderror" id="floatingInput" placeholder="name@example.com">
                                        <label for="floatingInput">Email * :</label>
                                        @error('email')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>                        
                                </div>
                                <!-- Téléphone -->
                                <div class="col-sm-12 col-md-6 col-lg-6">
                                    <div class="form-floating mb-3">
                                        <input type="text" name="telephone" value="{{ old('telephone') }}" class="form-control @error('telephone') is-invalid @enderror" id="floatingInput" placeholder="name@example.com">
                                        <label for="floatingInput">Téléphone * :</label>
                                        @error('telephone')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>                        
                                </div>
                            </div>
                            <div class="row">
                                <!-- Address -->
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <div class="form-floating mb-4">
                                        <input type="text" name="address" value="{{ old('address') }}" class="form-control @error('address') is-invalid @enderror" placeholder="Conakry">
                                        <label for="floatingPassword">Adresse * :</label>
                                        @error('address')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-md-6 col-lg-6">
                                    <div class="form-floating mb-4">
                                        <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" id="floatingPassword" placeholder="Password">
                                        <label for="floatingPassword">Mot de passe * :</label>
                                        @error('password')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-6">
                                    <div class="form-floating mb-4">
                                        <input type="password" name="password_confirmation" class="form-control @error('confirmation_mot_de_passe') is-invalid @enderror" id="floatingPassword" placeholder="Password">
                                        <label for="floatingPassword">Confirmer le Mot de passe * :</label>
                                        @error('confirmation_mot_de_passe')
                                            <span class="invalid-feedback">
                                                {{ $message }}
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-md-12 col-lg-12">
                                    <button type="submit" class="btn btn-secondary py-3 w-100 mb-4">Je m'inscris</button>
                                    <p class="text-center mb-0">Vous avez déjà un compte? <a href="{{ route('login') }}" title="Cliquer pour se connecter" class="text-secondary">Se connecter</a></p>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
