// Déconnexion automatique de l'utilisateur après un certain temps d'inactivité
var inactivityTime = function () {
    var time;
    var executed = false; // Variable pour s'assurer que le code ne s'exécute qu'une seule fois

    // Réinitialise le minuteur à chaque chargement de la page
    window.onload = resetTimer;

    // Capture des interactions utilisateur
    window.onmousemove = resetTimer; // Mouvements de la souris
    window.onmousedown = resetTimer; // Clics de la souris
    window.ontouchstart = resetTimer; // Touches tactiles (pour appareils mobiles)
    window.onclick = resetTimer; // Clics de la souris
    window.onkeypress = resetTimer; // Frappes au clavier

    // Fonction qui redirige l'utilisateur vers la page de déconnexion après une période d'inactivité
    function logout() {
        if (!executed) {
            executed = true; // Marque l'exécution comme terminée
            window.location.href = '/logout'; // Redirige vers la déconnexion
        }
    }

    // Fonction qui réinitialise le minuteur d'inactivité
    function resetTimer() {
        if (!executed) { // Ne fait rien si le code a déjà été exécuté
            clearTimeout(time); // Réinitialise le minuteur précédent
            time = setTimeout(logout, 120 * 60 * 1000); // Fixe un nouveau minuteur de 10 minutes
        }
    }
};

// Appelle la fonction pour démarrer le suivi de l'inactivité
inactivityTime();
