<?php

namespace Database\Seeders;

use App\Models\TypeDocument;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TypeDocumentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        # DNI
        TypeDocument::create([
            'id_categorie_document' => 1, 
            'libelle' => "Autorisation d’implantation",
            'id_service' => 1,
            'id_direction' => 1,
            'etat' => 1
        ]);

        TypeDocument::create([
            'id_categorie_document' => 1, 
            'libelle' => "Autorisation d’exploitation",
            'id_service' => 1,
            'id_direction' => 1,
            'etat' => 1
        ]);

        TypeDocument::create([
            'id_categorie_document' => 1, 
            'libelle' => "Autorisation d'extension",
            'id_service' => 1,
            'id_direction' => 1,
            'etat' => 1
        ]);

        # IGNM
        TypeDocument::create([
            'id_categorie_document' => 2, 
            'libelle' => "Attestation de conformité",
            'id_direction' => 2,
            'id_service' => 2,
            'etat' => 1
        ]);

        TypeDocument::create([
            'id_categorie_document' => 3, 
            'libelle' => "Certificat de jaugeage",
            'id_direction' => 2,
            'id_service' => 2,
            'etat' => 1
        ]);

        # APIP
        TypeDocument::create([
            'id_categorie_document' => 3, 
            'libelle' => "Agrément au code des investissements",
            'id_direction' => 3,
            'id_service' => 3,
            'etat' => 1
        ]);

        TypeDocument::create([
            'id_categorie_document' => 4, 
            'libelle' => "Création d'entreprise (RCCM / NIF)",
            'id_direction' => 3,
            'id_service' => 4,
            'etat' => 1
        ]); 

        # AGUIPEX
        TypeDocument::create([
            'id_categorie_document' => 1, 
            'libelle' => "Autorisation d'exportation du café",
            'id_direction' => 4,
            'id_service' => 5,
            'etat' => 1
        ]);

        TypeDocument::create([
            'id_categorie_document' => 1, 
            'libelle' => "Autorisation d'exportation d’huile",
            'id_direction' => 4,
            'id_service' => 5,
            'etat' => 1
        ]);

        TypeDocument::create([
            'id_categorie_document' => 3, 
            'libelle' => "Certificat conventionnel",
            'id_direction' => 4,
            'id_service' => 5,
            'etat' => 1
        ]);

        TypeDocument::create([
            'id_categorie_document' => 3, 
            'libelle' => "Certificat technique",
            'id_direction' => 4,
            'id_service' => 5,
            'etat' => 1
        ]);

        # DNCIC
        TypeDocument::create([
            'id_categorie_document' => 3, 
            'libelle' => "Certificat de mise sur le marché",
            'id_direction' => 5,
            'id_service' => 6,
            'etat' => 1
        ]);

        TypeDocument::create([
            'id_categorie_document' => 1, 
            'libelle' => "Autorisation d'exportation",
            'id_direction' => 5,
            'id_service' => 6,
            'etat' => 1
        ]);

        # ONCQ
        TypeDocument::create([
            'id_categorie_document' => 3, 
            'libelle' => "Certificat d’analyse de contrôle de qualité",
            'id_direction' => 6,
            'id_service' => 7,
            'etat' => 1
        ]);
        
        # DDI-DDE
        TypeDocument::create([
            'id_categorie_document' => 5, 
            'libelle' => "Intention d’importation",
            'id_direction' => 7,
            'id_service' => 8,
            'etat' => 1
        ]);

        TypeDocument::create([
            'id_categorie_document' => 5, 
            'libelle' => "Intention d'exportation",
            'id_direction' => 2,
            'id_service' => 8,
            'etat' => 1
        ]);
    }
}
