<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PrivilegesSeeder extends Seeder {
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        # Create permissions
        Permission::create(['name' => 'create user']);
        Permission::create(['name' => 'show user']);
        Permission::create(['name' => 'edit user']);
        Permission::create(['name' => 'delete user']);

        Permission::create(['name' => 'create document type']);
        Permission::create(['name' => 'show document type']);
        Permission::create(['name' => 'edit document type']);
        Permission::create(['name' => 'delete document type']);
        
        Permission::create(['name' => 'create document']);
        Permission::create(['name' => 'show document']);
        Permission::create(['name' => 'edit document']);
        Permission::create(['name' => 'delete document']);

        Permission::create(['name' => 'create product']);
        Permission::create(['name' => 'show product']);
        Permission::create(['name' => 'edit product']);
        Permission::create(['name' => 'delete product']);
        
        // # Create Roles
        Role::create(['name' => 'super_admin'])->givePermissionTo(Permission::all()); // Assign all permissions to super_admin role
        Role::create(['name' => 'admin']);
        Role::create(['name' => 'user']);
        
        Role::create(['name' => 'ministre']);
        Role::create(['name' => 'chef_cabinet']);
        Role::create(['name' => 'secretaire_general']);
        Role::create(['name' => 'directeur']);
        Role::create(['name' => 'chef_service']);
        Role::create(['name' => 'chef_section']);

        Role::create(['name' => 'superviseur']);
        Role::create(['name' => 'dni']);
        Role::create(['name' => 'ignm']);
        Role::create(['name' => 'apip']);
        Role::create(['name' => 'aguipex']);
        Role::create(['name' => 'dncic']);
        Role::create(['name' => 'oncq']);
        Role::create(['name' => 'ddi_dde']);
        Role::create(['name' => 'service_dni']);
        Role::create(['name' => 'service_ignm']);
        Role::create(['name' => 'service_code_investissement']);
        Role::create(['name' => 'guichet_unique_creation_entreprise']);
        Role::create(['name' => 'departement_certification_reglementation']);
        Role::create(['name' => 'service_dncic']);
        Role::create(['name' => 'service_oncq']);
        Role::create(['name' => 'service_ddi_dde']);
    }
}
