<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demande_renvoyees', function (Blueprint $table) {
            $table->id('id_demande_renvoyee');
            $table->foreignId('id_demande')
                    ->nullable()
                    ->constrained('demandes')
                    ->references('id_demande')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            $table->text('motif_renvoi')->nullable();
            $table->json('documents_joints')->nullable();
            $table->dateTime('date_renvoi');
            $table->timestamps();
            $table->boolean('etat')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demande_renvoyees');
    }
};
