<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('type_documents', function (Blueprint $table) {
            $table->after('id_direction', function (Blueprint $table) {
                $table->foreignId('id_service')
                    ->nullable()
                    ->constrained('services')
                    ->references('id_service')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('type_documents', function (Blueprint $table) {
            $table->dropForeign('type_documents_id_service_foreign');
            $table->dropColumn('id_service');
        });
    }
};
