<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('type_documents', function (Blueprint $table) {
            $table->after('montant', function (Blueprint $table) {
                $table->foreignId('id_direction')
                    ->nullable()
                    ->constrained('directions')
                    ->references('id_direction')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('type_documents', function (Blueprint $table) {
            $table->dropForeign('type_documents_id_direction_foreign');
            $table->dropColumn('id_direction');
        });
    }
};
