<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demande_traitees', function (Blueprint $table) {
            $table->id('id_demande_traitee');
            $table->foreignId('user_id')
                    ->nullable()
                    ->constrained('users')
                    ->references('user_id')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            $table->foreignId('id_promoteur')
                    ->nullable()
                    ->constrained('promoteurs')
                    ->references('id_promoteur')
                    ->onDelete(action: 'cascade')
                    ->onUpdate('cascade');
            $table->foreignId('id_demande')
                    ->nullable()
                    ->constrained('demandes')
                    ->references('id_demande')
                    ->onDelete(action: 'cascade')
                    ->onUpdate('cascade');
            $table->json('documents_joints');
            $table->text('commentaire')->nullable();
            $table->dateTime('date_traitement');
            $table->timestamps();
            $table->boolean('etat')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demande_traitees');
    }
};
