<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demande_rejetees', function (Blueprint $table) {
            $table->id('id_demande_rejetee');
            $table->foreignId('id_demande')
                    ->nullable()
                    ->constrained('demandes')
                    ->references('id_demande')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            $table->text('motif_rejet');
            $table->dateTime('date_rejet');
            $table->timestamps();
            $table->boolean('etat')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demande_rejetees');
    }
};
