<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demande_directions', function (Blueprint $table) {
            $table->id('id_demande_direction');
            $table->foreignId('id_demande')
                    ->nullable()
                    ->constrained('demandes')
                    ->references('id_demande')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            $table->foreignId('id_direction')
                ->nullable()
                ->constrained('directions')
                ->references('id_direction')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->dateTime('date_orientation');
            $table->foreignId('id_statut_demande')
                    ->nullable()
                    ->constrained('statut_demandes')
                    ->references('id_statut_demande')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            $table->timestamps();
            $table->boolean('etat')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demande_directions');
    }
};
