<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('demandes', function (Blueprint $table) {
            $table->after('date_demande', function (Blueprint $table) {
                $table->foreignId('id_statut_demande')
                    ->nullable()
                    ->constrained('statut_demandes')
                    ->references('id_statut_demande')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('demandes', function (Blueprint $table) {
            $table->dropForeign('demandes_id_statut_demande_foreign');
            $table->dropColumn('id_statut_demande');
        });
    }
};
