<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->after('id_categorie_utilisateur', function (Blueprint $table) {
                $table->foreignId('id_etat_utilisateur')
                    ->nullable()
                    ->constrained('etat_utilisateurs')
                    ->references('id_etat_utilisateur')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            });
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign('users_id_etat_utilisateur_foreign');
            $table->dropColumn('id_etat_utilisateur');
        });
    }
};
