<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('produits', function (Blueprint $table) {
            $table->id('id_produit');
            $table->string('nom');
            $table->foreignId('id_promoteur')
                    ->nullable()
                    ->constrained('promoteurs')
                    ->references('id_promoteur')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->foreignId('user_id')
                    ->nullable()
                    ->constrained('users')
                    ->references('user_id')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->boolean('etat')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('produits');
    }
};
