<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('archives', function (Blueprint $table) {
            $table->id('id_archive');
            $table->foreignId('id_demande')
                    ->nullable()
                    ->constrained('demandes')
                    ->references('id_demande')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->foreignId('id_type_document')
                    ->nullable()
                    ->constrained('type_documents')
                    ->references('id_type_document')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->foreignId('id_promoteur')
                    ->nullable()
                    ->constrained('promoteurs')
                    ->references('id_promoteur')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->foreignId('id_statut_demande')
                    ->nullable()
                    ->constrained('statut_demandes')
                    ->references('id_statut_demande')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->foreignId('user_id')
                    ->nullable()
                    ->constrained('users')
                    ->references('user_id')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->text('commentaire')->nullable();
            $table->timestamp('date_archivage')->useCurrent();
            $table->boolean('etat')->default(1);
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('archives');
    }
};
