<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statut_demandes', function (Blueprint $table) {
            $table->id('id_statut_demande');
            $table->string('libelle');
            $table->foreignId('user_id')
                    ->nullable()
                    ->constrained('users')
                    ->references('user_id')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statut_demandes');
    }
};
