<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('paiements', function (Blueprint $table) {
            $table->id('id_paiement');
            $table->string('reference_paiement');
            $table->foreignId('id_mode_paiement')
                    ->nullable()
                    ->constrained('mode_paiements')
                    ->references('id_mode_paiement')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->foreignId('id_demande')
                    ->nullable()
                    ->constrained('demandes')
                    ->references('id_demande')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->foreignId('id_type_document')
                    ->nullable()
                    ->constrained('type_documents')
                    ->references('id_type_document')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->foreignId('user_id')
                    ->nullable()
                    ->constrained('users')
                    ->references('user_id')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->string('justificatif')->nullable();
            $table->dateTime('date_paiement');
            $table->boolean('etat')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('paiements');
    }
};
