<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('demandes', function (Blueprint $table) {
            $table->id('id_demande');
            $table->foreignId('id_promoteur')
                    ->nullable()
                    ->constrained('promoteurs')
                    ->references('id_promoteur')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            $table->string('titre_demande');
            $table->foreignId('id_type_document')
                    ->nullable()
                    ->constrained('type_documents')
                    ->references('id_type_document')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            $table->json('documents_joints')->nullable();
            $table->foreignId('id_mode_paiement')
                    ->nullable()
                    ->constrained('mode_paiements')
                    ->references('id_mode_paiement')
                    ->onDelete('cascade')
                    ->onUpdate('cascade');
            $table->string('reference_paiement')->nullable();
            $table->string('justificatif')->nullable();
            $table->text('commentaire')->nullable();
            $table->dateTime('date_demande');
            $table->boolean('etat')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('demandes');
    }
};
