<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('responsables', function (Blueprint $table) {
            $table->id('id_responsable');
            $table->string('nom');
            $table->string('prenom')->nullable();
            $table->string('email')->nullable();
            $table->string('telephone', 20)->nullable();
            $table->string('adresse')->nullable();
            $table->foreignId('id_fonction')
                    ->nullable()
                    ->constrained('fonctions')
                    ->references('id_fonction')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->foreignId('user_id')
                    ->nullable()
                    ->constrained('users')
                    ->references('user_id')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('responsables');
    }
};
