<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ministeres', function (Blueprint $table) {
            $table->id('id_ministere');
            $table->string('nom');
            $table->string('email')->nullable();
            $table->string('telephone')->nullable();
            $table->string('localisation')->nullable();
            $table->string('site_web')->nullable();
            $table->string('logo')->nullable();
            $table->text('mission')->nullable();
            $table->boolean('etat')->default(1);
            $table->foreignId('user_id')
                    ->nullable()
                    ->constrained('users')
                    ->references('user_id')
                    ->onDelete('set null')
                    ->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ministeres');
    }
};
