<?php

namespace App\Notifications\Demande;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class DemandeSendNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $url = url(route('demande.index', false));
        return (new MailMessage)
                    ->subject('Demande envoyée')
                    ->greeting('Bonjour,')
                    ->line('Votre votre demande a bien été envoyée et est en attente de traitement.')
                    ->line("Vous pouvez suivre son évolution en cliquant sur le bouton ci-dessous:")
                    ->action('Voir mes demandes', $url)
                    ->salutation('Cordialement');
        // return (new MailMessage)
        //     ->subject('Demande envoyée')
        //     ->view('notifications.demande-send-notification', ['notifiable' => $notifiable]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
