<?php

namespace App\Notifications\Demande;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class DemandeReturnNotification extends Notification
{
    use Queueable;

    private $fichiers;

    /**
     * Create a new notification instance.
     */
    public function __construct(array $fichiers)
    {
        $this->fichiers = $fichiers;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $url = url(route('demande.index', false));
        $mail = (new MailMessage)
            ->subject('Renvoi pour modification')
            ->greeting('Bonjour,')
            ->line('Votre votre demande a été retournée pour modification. Veuillez vous connecter pour voir les détails.')
            ->action('Voir les demandes', $url)
            ->salutation('Cordialement');
            foreach ($this->fichiers as $fichier) {
                $mail->attach(storage_path('app/public/documents_recus/'.$fichier), [
                    'as' => $fichier,
                ]);
            }
        return $mail;
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
