<?php

namespace App\Notifications\Demande;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class DemandeRejectNotification extends Notification
{
    use Queueable;

    private $motif;

    /**
     * Create a new notification instance.
     */
    public function __construct($motif)
    {
        $this->motif = $motif;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('Demande Rejetée')
                    ->greeting('Bonjour,')
                    ->line('Nous sommes désolé de vous informer que votre demande a été rejetée pour le motif suivant: ')
                    ->line($this->motif)
                    ->line("Merci pour l'intérêt que vous portez à nos services.")
                    ->salutation('Cordialement');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
