<?php

namespace App\Notifications\Demande;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class DemandeProcessNotification extends Notification
{
    use Queueable;

    private $fichiers;
    private $message;

    /**
     * Create a new notification instance.
     */
    public function __construct(array $fichiers, $message)
    {
        $this->fichiers = $fichiers;
        $this->message = $message;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $mail = (new MailMessage)
            ->subject('Demandé traitée')
            ->greeting('Bonjour,')
            ->line($this->message)
            ->line("Vous trouverez ci-joint(s) le(s) document(s) sollicité(s).")
            ->salutation('Cordialement');
            foreach ($this->fichiers as $fichier) {
                $mail->attach(storage_path('app/public/documents_envoyes/'.$fichier), [
                    'as' => $fichier,
                ]);
            }
        return $mail;
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
