<?php

namespace App\Notifications\Auth;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class RegisterUserNotification extends Notification
{
    use Queueable;

    public $token;

    /**
     * Create a new notification instance.
     */
    public function __construct($token)
    {
        $this->token = $token;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail($notifiable): MailMessage
    {
        $url = url(route('verify.email', $this->token, false));

        return (new MailMessage)
                    ->subject('Notification de confirmation par e-mail')
                    ->greeting('Bonjour!')
                    ->line('Vous recevez cet e-mail car nous avons reçu une demande de création de compte.')
                    ->action('Confirmez votre email', $url)
                    ->line('Si vous rencontrez des difficultés pour cliquer sur le bouton « Confirmez votre email », copiez et collez l\'URL suivante dans votre navigateur Web : '.$url.'')
                    ->salutation('Cordialement');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
