<?php

namespace App\Notifications\Auth;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class AccountCreationNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $loginUrl = url(route('login', false));
        $forgotPasswordUrl =  url(route('password.request', false));
        
        return (new MailMessage)                    
                    ->subject('Votre compte a été créé')
                    ->greeting('Bonjour et bienvenue!')
                    ->line('Votre compte utilisateur a été créé avec succès et nous sommes ravis de vous compter parmi nous. Vous pouvez désormais vous connecter en utilisant le mot de passe suivant : 123456. Pour des raisons de sécurité, nous vous recommandons de le modifier dès que possible.')
                    ->line('Veuillez cliquer sur le bouton ci-dessous pour vous connecter.')
                    ->action('Se connecter', $loginUrl)
                    ->salutation('Cordialement');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
