<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TypeDocument extends Model
{
    use HasFactory;

    protected $table = 'type_documents';
    protected $primaryKey = 'id_type_document';
    protected $guarded = [];

    public function categorieDocument()
    {
        return $this->belongsTo(CategorieDocument::class, 'id_categorie_document');
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'id_service');
    }

    public function direction()
    {
        return $this->belongsTo(Direction::class, 'id_direction');
    }
}
