<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Promoteur extends Model
{
    use HasFactory;

    protected $table = 'promoteurs';
    protected $primaryKey = 'id_promoteur';
    protected $guarded = [];
    
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    
    public function demandes()
    {
        return $this->hasMany(Demande::class, 'id_promoteur');
    }
}
