<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Direction extends Model
{
    use HasFactory;

    protected $table = 'directions';
    protected $primaryKey = 'id_direction';
    protected $guarded = [];

    public function ministere()
    {
        return $this->belongsTo(Ministere::class, 'id_ministere');
    }

    public function services()
    {
        return $this->hasMany(Service::class, 'id_direction');
    }
}
