<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DemandeTraitee extends Model
{
    use HasFactory;

    protected $table = 'demande_traitees';
    protected $primaryKey = 'id_demande_traitee';
    protected $guarded = [];

    protected $casts = [
        'documents_joints' => 'array',
    ];

    public function demande()
    {
        return $this->belongsTo(Demande::class, 'id_demande');
    }

    public function promoteur()
    {
        return $this->belongsTo(Promoteur::class, 'id_promoteur');
    }
}
