<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Demande extends Model
{
    use HasFactory;

    protected $table = 'demandes';
    protected $primaryKey = 'id_demande';
    protected $guarded = [];

    protected $casts = [
        'documents_joints' => 'array',
    ];

    public function promoteur()
    {
        return $this->belongsTo(Promoteur::class, 'id_promoteur');
    }

    public function typeDocument()
    {
        return $this->belongsTo(TypeDocument::class, 'id_type_document');
    }

    public function modePaiement()
    {
        return $this->belongsTo(ModePaiement::class, 'id_mode_paiement');
    }

    public function statutDemande()
    {
        return $this->belongsTo(StatutDemande::class, 'id_statut_demande');
    }

}
