<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Archive extends Model
{
    use HasFactory;

    protected $table = 'archives';
    protected $primaryKey = 'id_archive';
    protected $guarded = [];

    public function demande()
    {
        return $this->belongsTo(Demande::class, 'id_demande');
    }

    public function typeDocument()
    {
        return $this->belongsTo(TypeDocument::class, 'id_type_document');
    }

    public function promoteur()
    {
        return $this->belongsTo(Promoteur::class, 'id_promoteur');
    }

    public function statutDemande()
    {
        return $this->belongsTo(StatutDemande::class, 'id_statut_demande');
    }
}
