<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class updateServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
           "id_direction"=>"required",
            "nom"=>"required",
            "email"=>"required",
            "telephone"=>"required",
            "localisation"=>"required",
            "mission"=>"required",
        ];
    }

    public function messages()
    {
        return [
            'id_direction.required'=>"La direction est requise",
            'nom.required'=>"Le nom est requis",
            'email.required'=>"L'email est requis",
            'email.email'=>"Mauvais format d'email",
            'telephone.required'=>"Le numéro de téléphone est requis",
            'localisation.required'=>"La localisation est requise",
            'mission.required'=>"La mission est requise",
        ];
    }
}
