<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class storeResponsableRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "nom"=>"required",
            "prenom"=>"required",
            "email"=>"required|unique:responsables,email",
            "telephone"=>"required|unique:responsables,telephone",
            "adresse"=>"required",
            "id_fonction"=>"required",
        ];
    }

    public function messages()
    {
        return [
            'nom.required'=>"Le nom est requis",
            'prenom.required'=>"Le prenom est requis",
            'email.required'=>"L'email est requis",
            'email.email'=>"Mauvais format d'email",
            'email.unique'=>"L'email existe déjà",
            'telephone.required'=>"Le numéro de téléphone est requis",
            'telephone.unique'=>"Le numéro de téléphone existe déjà",
            'adresse.required'=>"L'adresse est requise",
            'id_fonction.required'=>"La fonction est requise",
        ];
    }
}
