<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class storePromoteurRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "nom"=>"required",
            "prenom"=>"required",
            "nom_entreprise"=>"required",
            "email"=>"required|unique:promoteurs,email",
            "telephone"=>"required|unique:promoteurs,telephone",
            "adresse"=>"required",
        ];
    }

    public function messages()
    {
        return [
            'nom.required'=>"Le nom est requis",
            'prenom.required'=>"Le prenom est requis",
            'nom_entreprise.required'=>"Le nom d'entreprise est requis",
            'email.required'=>"L'email est requis",
            'email.email'=>"Mauvais format d'email",
            'email.unique'=>"L'email existe déjà",
            'telephone.required'=>"Le numéro de téléphone est requis",
            'telephone.unique'=>"Le numéro de téléphone existe déjà",
            'adresse.required'=>"L'adresse est requise",
        ];
    }
}
