<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreDirectionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "id_ministere"=>"required",
            "nom"=>"required",
            "email"=>"required|unique:directions,email",
            "telephone"=>"required|unique:directions,telephone",
            "localisation"=>"required",
            "site_web"=>"required",
            "logo"=>"required",
            "mission"=>"required",
        ];
    }

    public function messages()
    {
        return [
            'id_ministere.required'=>"Le ministère est requis",
            'nom.required'=>"Le nom est requis",
            'email.required'=>"L'email est requis",
            'email.email'=>"Mauvais format d'email",
            'email.unique'=>"L'email existe déjà",
            'telephone.required'=>"Le numéro de téléphone est requis",
            'telephone.unique'=>"Le numéro de téléphone existe déjà",
            'localisation.required'=>"La localisation est requise",
            'site_web.required'=>"Le site web est requis",
            'logo.required'=>"Le logo est requis",
            'mission.required'=>"La mission est requise",
        ];
    }
}
