<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DemandeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function rules(): array
    {
        return [
            'demande_title' => 'required',
            'document_type' => 'required',
            'attachments' => 'required',
            // 'attachments' => 'required|file|mimes:jpg,jpeg,png,pdf,doc,docx,xls,xlsx|max:2048',
            // 'payment_mode' => 'required',
            // 'payment_reference' => 'required',
            // 'proof' => 'required'
            // 'commentary' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'demande_title.required' => 'Le titre de la demande est obligatoire.',
            'document_type.required' => 'Le type de document est obligatoire.',
            'attachments.required' => 'Vous devez joindre au moins un document.',
            // 'attachments.file' => 'Les documents doivent avoir un des types suivants jpg, jpeg, png, pdf, doc, docx, xls, xlsx.',
            'payment_mode.required' => 'Vous devez choisir un mode de paiement.',
            'payment_reference.required' => 'La référence du paiement est obligatoire.',
            'proof.required' => 'Vous devez joindre la pièce justificative.',
            'commentary.required' => 'La description est obligatoire.',
        ];
    }
}
