<?php

namespace App\Http\Requests\Auth;

use Illuminate\Foundation\Http\FormRequest;

class RegisterUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'gender' => 'required',
            'company' => 'required',
            'email' => 'required|email|unique:users,email',
            'telephone' => 'required',
            'address' => 'required',
            'password' => 'required|confirmed|min:6',
        ];
    }

    public function messages()
    {
        return [
            'first_name.required' => 'Le prénom est obligatoire.',
            'last_name.required' => 'Le nom est obligatoire.',
            'gender.required' => 'Vous devez renseigner le genre.',
            'company.required' => 'Vous devez renseigner l\'entreprise.',
            'email.required' => 'L\'adresse email est obligatoire.',
            'email.email' => 'L\'adresse email saisie n\'est pas valide.',
            'email.unique' => 'Cette adresse email est déjà associée à un compte.',
            'telephone.required' => 'Vous devez renseigner un numéro de téléphone.',
            'address.required' => 'Vous devez renseigner l\'adresse.',
            'password.required' => 'Le mot de passe est obligatoire.',
            'password.min' => 'Le mot de passe doit être de 6 caractères minimum.',
            'password.confirmed' => 'Les mots de passe ne correspondent pas.',
        ];
    }
}
