<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class RoleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'role_name' => ['required', 'min:3', 'unique:roles,name'],
        ];
    }

    public function messages()
    {
        return [
            'role_name.required' => 'Le nom du rôle est obligatoire.',
            'role_name.unique' => 'Le nom du rôle doit être unique.',
            'role_name.min' => 'Le nom du rôle doit être de 3 caractères minimum.',
        ];
    }
}
