<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class ProductRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'product_name' => 'required',            
            // 'description' => 'required',
            'entity' => 'required',

        ];
    }

    public function messages() {
        return [
            'product_name.required' => 'Le nom du produit est obligatoire.',
            'description.required' => 'La description est obligatoire.',
            'entity.required' => "L'entité cible doit être renseignée.",
        ];
    }
}
