<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class PermissionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'permission_name' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'permission_name.required' => 'Le nom de la permission est obligatoire.',
            'permission_name.unique' => 'Le nom de permission doit être unique.',
            'permission_name.min' => 'Le nom du rôle doit être de 3 caractères minimum.',
        ];
    }
}
