<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class EntityRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'entity_name' => 'required|min:3|unique:entities,entity_name',
            'entity_type' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'entity_name.required' => 'Le nom de l\'entité est obligatoire.',
            'entity_name.min' => 'Le nom de l\'entité doit être de 3 caractères minimum.',
            'entity_name.unique' => 'Le nom de l\'entité doit être unique.',
            'entity_type.required' => 'Vous devez sélectionner le type de l\'entité.',
        ];
    }
}
