<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Notification;
use App\Notifications\Demande\DemandeNotification;
use Exception;
use Utilities;
use App\Models\User;
use App\Models\Demande;
use App\Models\FileType;
use App\Models\ModePaiement;
use App\Models\TypeDocument;
use Illuminate\Http\Request;
use App\Models\DemandeRejetee;
use App\Models\DemandeTraitee;
use App\Models\DemandeRenvoyee;
use App\Models\RejectedDemande;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\DemandeRequest;
use Illuminate\Notifications\Notifiable;
use App\Notifications\Demande\DemandeSendNotification;

class DemandeController extends Controller
{
    use Notifiable;

    public function index()
    {
        $promoteur = Auth::user()->promoteur->id_promoteur;
        # Liste de toutes les demandes
        $allDemandes = Demande::where('id_promoteur', $promoteur)->get();
        return view('frontend.pages.demandes.my-demandes', compact('allDemandes'));
    }

    public function demandeCategory($slug)
    {
        $promoteur = Auth::user()->promoteur->id_promoteur;
        # Liste de toutes les demandes
        $allDemandes = Demande::where('id_promoteur', $promoteur)->get();

        switch ($slug) {
            case "processing":
                # Liste des demandes en attente de traitement
                $demandes = Demande::where(['id_statut_demande' => 1, 'id_promoteur' => $promoteur])->get();
                return view('frontend.pages.demandes.categories.processing', compact('demandes'));
            case "study":
                # Liste des demandes en attente d'étude
                $demandes = Demande::where(['id_statut_demande' => 2, 'id_promoteur' => $promoteur])->get();
                return view('frontend.pages.demandes.categories.study', compact('demandes'));
            case "review":
                # Liste des demandes en attente d'examen
                $demandes = Demande::where(['id_statut_demande' => 3, 'id_promoteur' => $promoteur])->get();
                return view('frontend.pages.demandes.categories.review', compact('demandes'));
            case "modification":
                # Liste des demandes en attente de modification
                $demandes = DemandeRenvoyee::with(['demande' => function ($query) use ($promoteur) {
                    $query->where('id_statut_demande', 4)
                          ->where('id_promoteur', $promoteur);
                }])
                ->get()
                ->filter(function ($demandeRenvoyee) {
                    return $demandeRenvoyee->demande !== null;
                })
                ->unique('id_demande');
                return view('frontend.pages.demandes.categories.modification', compact('demandes'));
            case "rejected":
                # Liste des demandes rejetées
                $demandes = DemandeRejetee::select('demande_rejetees.*')
                    ->join('demandes', 'demandes.id_demande', '=', 'demande_rejetees.id_demande')
                    ->where('demandes.id_statut_demande', 5)
                    ->where('demandes.id_promoteur', $promoteur)
                    ->get();
                return view('frontend.pages.demandes.categories.rejected', compact('demandes'));
            case "processed":
                # Liste des demandes traitées
                $demandes = DemandeTraitee::select('demande_traitees.*')
                    ->join('demandes', 'demandes.id_demande', '=', 'demande_traitees.id_demande')
                    ->where('demandes.id_statut_demande', 6)
                    ->where('demandes.id_promoteur', $promoteur)
                    ->get();
                return view('frontend.pages.demandes.categories.processed', compact('demandes'));
            default:
                return view('frontend.pages.demandes.list', compact('allDemandes'));
        }
    }

    public function add()
    {
        $typeDocuments = TypeDocument::all();
        $modesPaiement = ModePaiement::all();
        return view('frontend.pages.demandes.add-demande', compact('typeDocuments', 'modesPaiement'));
    }

    public function store(DemandeRequest $request)
    {
        try {
            $user = Auth()->user();
            $demande = new Demande();
            $demande->id_promoteur = $user->promoteur->id_promoteur;
            $demande->titre_demande = $request->demande_title;
            $demande->id_type_document = $request->document_type;
            $files = [];
            if ($request->hasfile('attachments')) {
                $files = Utilities::setFiles($request->file('attachments'), 'documents_recus');
            }
            $demande->documents_joints = $files;
            $demande->id_mode_paiement = $request->payment_mode ?? NULL;
            $demande->reference_paiement = isset($request->payment_reference) ? $request->payment_reference : NULL;
            $demande->justificatif = isset($request->proof) ? $request->proof : NULL;
            $demande->commentaire = isset($request->commentary) ? $request->commentary : NULL;
            $demande->date_demande = now();
            $demande->id_statut_demande = 1; // En attente de traitement
            $demande->etat = 1; // Actif

            $demande->save();

            $user->notify(new DemandeSendNotification());

            $ministre = User::select('user_id', 'email')->where('email', 'ministre@mail.com')->first();
            $message = "Vous avez une demande en attente d'orientation.";
            Notification::create([
                'user_id' => $ministre->user_id,
                'message' => $message,
            ]);
            $ministre->notify(new DemandeNotification($message));
            return back()->with('success', 'Demande envoyée avec succès.');
        } catch (Exception $e) {
            dd($e->getMessage());
        }
    }
}
