<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreTypeDocumentRequest;
use App\Http\Requests\UpdateTypeDocumentRequest;
use App\Models\TypeDocument;
use App\Models\CategorieDocument;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TypeDocumentController extends Controller
{
    // Liste des types de documents actifs (état = 1)
    public function index()
    {
        $types = TypeDocument::with('categorieDocument')
        ->where('etat', 1) 
        ->paginate(10);
        return view('backend.pages.type_documents.list', compact('types'));
    }

    // Formulaire pour créer un nouveau type de document
    public function create()
    {
        $categories = CategorieDocument::where('etat', 1)->get(); // Récupérer les catégories actives
        return view('backend.pages.type_documents.add', compact('categories'));
    }

    // Enregistrer un type de document
    public function store(TypeDocument $type, StoreTypeDocumentRequest $request)
    {
        try {
            // Créer un nouveau type de document
            $type = new TypeDocument();
            $type->libelle = $request->libelle;
            $type->montant = $request->montant;
            $type->id_categorie_document = $request->id_categorie_document; // Associer la catégorie
            $type->etat = 1; // Par défaut, le type de document est actif
            $type->user_id = Auth::id();

            $type->save();

            return redirect()->route('type_document.index')->with('success', 'Type de document enregistré avec succès !');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de l'enregistrement du type de document.");
        }
    }

    // Formulaire pour éditer un type de document
    public function edit(TypeDocument $type)
    {
        $categories = CategorieDocument::where('etat', 1)->get(); // Récupérer les catégories actives
        return view('backend.pages.type_documents.edit', compact('type', 'categories'));
    }

    // Mettre à jour un type de document
    public function update(UpdateTypeDocumentRequest $request, TypeDocument $type)
    {
        try {
            $type->libelle = $request->libelle;
            $type->montant = $request->montant;
            $type->id_categorie_document = $request->id_categorie_document; // Mettre à jour la catégorie associée
            $type->save();

            return redirect()->route('type_document.index')->with('success', 'Type de document mis à jour avec succès !');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de la mise à jour du type de document.");
        }
    }

    // Désactiver un type de document (état = 0)
    public function disable(TypeDocument $type)
    {
        try {
            $type->etat = 0; // Désactiver le type de document
            $type->save();

            return redirect()->route('type_document.index')->with('success', 'Type de document désactivé avec succès !');
        } catch (Exception $e) {
            return redirect()->back()->with('error', "Une erreur est survenue lors de la désactivation du type de document.");
        }
    }
}
